#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=8
#SBATCH --job-name=cluster
#SBATCH --time=4:00:00
#SBATCH --mem=90G


PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'
EXP_STR="selav3/nonuniform-BS-512-EP200-3k-x3-2L6S-SK"
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL="${EXPERIMENT_PATH}/checkpoint.pth.tar"
DEV=0

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} cluster_eval.py --ckpt_path ${MODEL} \
    --dataset 'places' 2>&1 | tee -a  ${EXPERIMENT_PATH}/kmeans-places-val.txt

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} cluster_eval.py --ckpt_path ${MODEL} \
    --dataset 'flowers' 2>&1 | tee -a  ${EXPERIMENT_PATH}/kmeans-flowers-val.txt



PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'
EXP_STR="dino"
EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL="${EXPERIMENT_PATH}/checkpoint.pth.tar"
DEV=3

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} cluster_eval.py --ckpt_path ${MODEL} --deit \
    --dataset 'flowers' 2>&1 | tee -a  ${EXPERIMENT_PATH}/kmeans-flowers-val.txt

CUDA_VISIBLE_DEVICES=$DEV ${PYTHON} cluster_eval.py --ckpt_path ${MODEL} --deit \
    --dataset 'places' 2>&1 | tee -a  ${EXPERIMENT_PATH}/kmeans-places-val.txt


